## 登陆页面

### **1.功能概述**

本界面为智能IOT平台登录入口，通过简洁的界面设计实现用户身份验证功能，确保设备操作与数据管理的安全性。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/6825795ce5191.png)

### **2.操作流程**

#### **2.1 访问系统**

显示器分辨率>=1920 \* 1080，且谷歌内核浏览器（版本>=92）访问：
工智机ip地址:20021（如：192.168.111.174:20021）

#### **2.2 身份验证**

步骤1：在「用户名」输入框填写工号/注册账号

步骤2：在「密码」输入框输入对应密码（密码默认隐藏显示）

步骤3：点击蓝色「登录」按钮提交验证


## 辅助功能（通用）

### **1.分页控制**

#### **1.1 分页容量**

每页显示10条/20条/30条/40条/50条信息
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257971a9d89.png)

#### **1.2 翻页操作**

点击「<」「 >」 按钮翻页
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ac0687a5.png)

点击需要前往的页码跳转
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ad228895.png)

输入想要跳转的页码
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b0a8ac60.png)

### **2.筛选查询**

根据提示选择或输入筛选条件，点击「查询」按钮进行筛选，点击「重置」按钮清空筛选条件
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b1545b2f.png)

传感器管理页面独有「高级筛选」，点击「高级筛选」按钮后，弹出高级筛选侧边栏，内含更加丰富的筛选条件，其余操作同上
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b20cddc3.png)

### **3.数据排序**

部分数据列可进行排序，点击表头可进行升序、降序、取消排序操作
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b2f22154.png)

### **4.页面布局**

部分页面数据列过多，无法全部展示，需拖拽下方滚动条查看全部内容
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b3a8940e.png)

### **5.数据刷新**

点击「刷新」按钮强制更新页面内容
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b4479263.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b4db5494.png)

## IOTHub

### **1.传感器管理（首页）**

#### **1.1 功能概述**

运行实施人员可使用该功能完成有线、无线传感器的添加、删除、编辑、配置操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6ea1ce9b40.png)


#### **1.2 添加传感器**

在传感器管理页面的右上角，点击“添加传感器”按钮或者“批量添加”按钮，在出现添加弹窗后，根据以上传感器添加规则填写编号信息，选择产品型号后，点击确定按钮，即可添加成功
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b620774d.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b6b569e2.png)

在传感器添加时需注意传感器编号以SN开头，长度为10位，中间2位数字表示监测类型，最后6位为唯一序号。传感器产品型号与编号的对应关系如下：

| 产品型号         | 编号         | 产品类型              | 产品特性        |
| ------------ | ---------- | ----------------- | ----------- |
| SD-V3012-100 | SN11XXXXXX | 单轴有线加速度传感器        | 100mg       |
| SD-V3012-500 | SN11XXXXXX | 单轴有线加速度传感器        | 500mg       |
| SD-V3207-ZG  | SN12XXXXXX | 三轴无线zigbee加速度传感器  | 10k         |
| SD-V3207-4G  | SN13XXXXXX | 三轴无线4G-cat1加速度传感器 | 10k，4G-cat1 |

#### **1.3 传感器网关解绑**

传感器在绑定网关后进行删除操作时，可以在传感器列表页面以及传感器详情页面两处进行网关解绑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b79df023.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b82c6a8c.png)

#### **1.4 传感器删除**

在传感器没有绑定网关时，传感器的网关解绑按钮，不可点击，可以进行传感器删除操作；绑定过网关的传感器需解绑后才能进行删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b8d1ada9.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257b978fa4e.png)

#### **1.5 传感器详情**

添加成功的传感器会展示在传感器管理的列表界面，点击详情按钮，可以查看传感器的数据传输状态、基本信息、绑定信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ba7ca5e5.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bb1ee3e0.png)

### **2.数采网关管理**

#### **2.1 功能概述**

运维实施人员可使用该功能完成数采器、网关的添加、传感器绑定、采集配置下发、编辑、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bbe55bdc.png)

#### **2.2 数采网关添加**

进入到数采网关管理页面，点击页面右上角的“添加数采网关”按钮或者“批量添加”按钮，出现添加数采网关弹窗，填写和选择对应的“网关编号”、“产品型号”、“采集配置”、“特征值间隔”、“波形间隔”、“数据通讯方式”信息后，点击确定按钮，即可添加数采网关成功。其中“特征值间隔”、“波形间隔”单位默认是秒，“采集配置”需在字典管理模块的“采集配置”添加。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bc8564b8.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bd2760fd.png)

数采网关产品编号以GW开头，长度为8位，前两位固定为GW，中间一位表示网关类型，最后5位为唯一编号，网关产品和编号的对应关系如下：

| 产品型号           | 网关编号                                              | 产品类型      |
| -------------- | ------------------------------------------------- | --------- |
| SD-DA7008      | GW2XXXXX                                          | 8通道振动采集器  |
| SD-DA7016      | GW2XXXXX                                          | 16通道振动采集器 |
| SD-DA7024      | GW2XXXXX                                          | 24通道振动采集器 |
| SD-GW5001/5101 | GW11XXXXX GW12XXXXX GW13XXXXX GW14XXXXX GW15XXXXX | 振动网关      |
| SD-GW5200/5201 | GW16XXXXX GW17XXXXX GW18XXXXX GW19XXXXX           | 4G虚拟网关    |

#### **2.3 数采网关配置及下发**

数采网关添加完成后，需要绑定配置传感器，才能进行数据采集和传输操作，点击“通道配置”按钮，进入到传感器配置弹窗界面，点击“添加”按钮，输入传感器编号，点击“确定”按钮，即可绑定传感器到当前的数采网关。绑定完成后，点击“配置下发”按钮，出现二次确认弹窗后，点击“确定”按钮，数采网关信息以及传感器信息就能下发至数据采集平台，进行数据的采集上传。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257be5e8f88.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bf1d1a7b.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257bfd1f358.png)

#### **2.4 数采网关编辑**

对于添加完成的数采网关可以进行编辑操作，点击“编辑”按钮，进入到数采网关的编辑弹窗界面，其中“网关编号”、“产品型号”不允许编辑，其他信息可以进行更新修改，编辑完成后，点击“确定”按钮，即可更新数采网关信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c087e68e.png)

#### **2.5 数采网关删除**

数采网关在未绑定传感器时，可以进行删除操作；绑定了传感器的数采网关不允许进行删除，需解绑后才能删除成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c1115342.png)

#### **2.6 数采网关详情**

在数采网关列表页面，点击选中数采网关的网关编号，进入到数采网关的详情页面，可以查看数采网关的基本信息和绑定的传感器信息，在详情页面可以进行传感器的解绑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c1b88174.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c25bce8b.png)

### **3.IOT网关管理**

#### **3.1 功能概述**

运维实施人员可使用该功能完成IOT网关的添加、编辑、点位配置、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c34164ca.png)

#### **3.2 IOT网关添加**

目前工艺量网关支持的产品型号只有“SD-GW3000”，协议支持“RMQ”、“MQTT”、“OPCUA”、“API”、“页面集成”几种方式。“组态实时转发”的开关决定，工艺数据是否转发至组态编译平台，默认为关闭状态。进入到IOT网关管理页面，点击“添加网关”按钮，出现添加iot网关弹窗界面，填写相关信息后，点击“确定”按钮，即可添加IOT网关成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c412abdf.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c4abfa91.png)

#### **3.3 IOT网关详情**

添加完成的IOT网关会显示在IOT网关管理的列表页面，点击对应IOT网关的“详情”按钮，进入选中IOT网关的详情页面，详情页面展示IOT网关的基本信息和工艺量点位的实时看板信息。当前页面可进行点位的配置、启用、停用、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c5f659f0.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c5f8061e.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c5f97d6b.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c5fa9281.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c5fa4c8a.png)

#### **3.4 IOT网关编辑**

点击IOT网关操作栏的“编辑”按钮，进入到编辑弹窗界面，进行网关的编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c94e60f9.png)

#### **3.5 IOT网关删除**

已添加的IOT网关，在未绑定点位信息时，可进行删除操作，若已绑定点位，需解绑点位后才能删除成功。点击网关列表操作栏的“删除”按钮，即可对选中IOT网关进行删除操作，删除操作需二次确认。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257c9e97fe7.png)

## 组态管理

### **1.机组管理**

#### **1.1 功能概述**

机组管理模块，可以进行机组的添加、编辑、删除、测点添加、机组详情查看操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e99de5480.png)


#### **1.2 无线振动测点添加**

点击机组后方的更多按钮选择无线振动测点添加，在弹窗内填写信息进行添加
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cb75a5ed.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cb75a0b5.png)

#### **1.3 转速配置**

点击机组后方的更多按钮选择转速配置，在弹窗内填写信息进行配置
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cc309a8e.png)

#### **1.4 工艺测点配置**

点击机组后方的更多按钮选择工艺测点配置，在弹窗内填写信息进行配置
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cce382d3.png)

#### **1.5 有线振动测点添加**

点击机组后方的更多按钮选择有线振动测点添加，在弹窗内填写信息进行添加
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cd9c71ac.png)

#### **1.6 控制测点添加**

点击机组后方的更多按钮选择控制测点添加，在弹窗内填写信息进行添加
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ce3ca288.png)

#### **1.7 机组详情**

点击机组后方的详情按钮可以进入详情界面
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ced2f322.png)

详情界面点击右上角配置测点按钮可以进行无线振动测点添加、转速配置、工艺测点配置、有线振动测点添加、控制测点添加操作
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257cf90cbb6.png)

点击学习按钮可以进行算法手动学习，点击下方次数蓝字还可以查看学习算法的详情
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d0228d9e.png)

点击查看蓝字可以查看设备参数
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d1f30737.png)

下方还可以对测点进行详情查看
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d2c295ab.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d2c18e88.png)
编辑操作
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d3772ba1.png)

删除操作
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d4257eb8.png)

### **2.测点管理**

#### **2.1 功能概述**

集中管理物联网设备的测点信息，提供数据展示、快速检索、层级化导航及操作管理能力
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d4b25c69.png)

#### **2.2 查看详情**

点击测点后方的详情按钮可以查看该测点的具体详情
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d56b5fc6.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257d569cd13.png)

## 算法管理

### **1.算法管理**

#### **1.1 功能概述**

支持管理员通过算法名称快速查询算法列表，并可进行添加、编辑、删除等操作。记录版本、上传时间等数据，确保算法可追溯与高效维护，助力设备智能化运维。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e700b03d7.png)


#### **1.2 算法添加**

点击页面右上角的“添加算法”按钮，出现添加算法的弹窗界面，填写必填信息，点击确定按钮，即可添加算法成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e70bb6d9a.png)



#### **1.3 算法编辑**

已添加的算法，需要进行编辑操作时，点击“编辑”按钮，出现修改算法的弹窗界面，修改完成后，点击确定按钮，更新算法成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e73c3e76c.png)



#### **1.4 算法删除**

在算法未被算法流绑定使用时，可以进行删除操作，已绑定算法流的算法需先进行算法流解绑操作后进行删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e74e3b8b9.png)

#### **1.5 算法学习**

算法被算法流使用之后，算法流中绑定的机组数据在达到自动学习条件时，均会进行自动学习任务的创建。用户在自动学习算法管理页面手动点击学习按钮，也会触发学习任务。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e77639d40.png)


#### **1.6 机组绑定**
点击列表中的“机组绑定”按钮，进入到算法机组绑定弹窗界面，勾选想要绑定到算法流的机组后，点击确定按钮，完成算法与机组的绑定操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68a6e78bd9bd4.png)



### **2.任务管理**

#### **2.1 功能概述**

任务管理模块，主要展示算法的信号处理算法任务、状态预测算法任务、自动学习算法任务的信息，可以通过算法名称、任务状态、采集时间、机组名称和所属组织进行查询操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257dc452820.png)

#### **2.2 任务详情**

点击任务后方的查看按钮，会出现点击任务的详情弹窗，展示任务的基本信息、数据信息、日志信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257dd03cbf8.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257dd03ca1e.png)

## 开发接入管理

### **1.对接方管理**

#### **1.1 功能概述**

对接方管理模块主要有对接方的添加、对接方编辑、接口分配、设备关联、对接方的启用、停用、对接方删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ddcd6db5.png)

#### **1.2 添加对接方**

进入对接方管理页面，点击页面右上角的“添加”按钮，进入对接方的添加界面，填写对接方的基本信息、服务器信息后，点击“提交”按钮，完成对接方的添加。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257deac260d.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257deaad08f.png)

#### **1.3 编辑对接方**

已添加的对接方可以进行编辑操作，鼠标悬浮到“...”上，点击“编辑”按钮，进入到对接方的编辑界面，可以对对接方进行编辑修改操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257df5979f2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257df591bd7.png)

#### **1.4 对接方启用、停用**

默认新添加的对接方为启用状态，鼠标点击停用按钮后，对接方变为停用状态，停用的对接方可以重新启用。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257dffcba3c.png)

只有停用的对接方才能进行删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e0aeeae8.png)

#### **1.5 接口分配**

对接方的数据传送和接收都是通过接口进行的，在对接方管理过程中接口分配通过点击界面的“接口分配”按钮，进入弹窗界面，分配对应的接口和每日最大调用次数，超过调用次数后，当日不再进行数据接收和数据推送。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e138c1fd.png)

#### **1.6 设备关联**

对接方与设备关联后，设备产生的一些数据，都可以通过对接方推送给用户或者接收到用户的设备信息后可以展示到智能诊断平台。设备关联操作需要点击页面的“设备关联”按钮，进入弹窗界面，勾选需要关联的设备后，点击确认按钮即可。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e1e52e1c.png)

#### **1.7 对接方详情**

添加完成的对接方会有一个appID，点击对接方的appID，可以进入到对接方详情页面，展示对接方的基本信息，数据对接信息、接口绑定信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e2beb860.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e2beaebb.png)

### **2.接口管理**

#### **2.1 功能概述**

接口管理主要有接口的添加、接口编辑、对接方绑定、接口的启用、停用、接口删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e3516a79.png)

#### **2.2 添加接口**

点击页面右上角“添加”按钮，出现接口添加弹窗，填写对应的接口信息后，点击确定按钮，即可添加接口成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e3eec694.png)

#### **2.3 接口编辑**

已添加的接口需要更新修改操作时，点击页面的“编辑”按钮，出现编辑弹窗，更新需要修改的信息后，点击确定按钮，完成接口编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e496d9f2.png)

#### **2.4 接口启停用、接口删除**

新添加的接口默认为启用状态，鼠标点击停用按钮，可以进行状态切换，只有在停用状态的接口才能进行删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e70705eb.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e706d5c0.png)

#### **2.5 接口详情**

点击接口的接口名称，进入到接口详情页面，展示接口的接口信息和对接方信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e7e3532e.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e7e2ae1e.png)

### **3、日志管理**

#### **3.1 功能概述**

日志管理模块，主要展示对接方的消息接收和数据推送日志信息，通过对接方名称、接口名称、调用结果、调用时间可以进行日志查询操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e871d376.png)

#### **3.2 查看详情**

点击日志消息的消息ID可以查看消息的详情信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e9026b51.png)

## 字典管理

### **1.轴承管理**

#### **1.1 功能概述**

轴承管理模块，主要是轴承的添加、编辑、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257e9ab2215.png)

#### **1.2 轴承添加**

点击页面右上角的“添加轴承”按钮，出现添加轴承的弹窗界面，填写轴承的相关信息后，点击确定按钮即可添加成功。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ea3b59e2.png)

#### **1.3 轴承编辑**

已添加的轴承会展示在轴承管理的轴承列表页面，点击轴承的“编辑”按钮，进入选中轴承的编辑弹窗界面，更新轴承信息后，点击确定按钮，完成轴承的编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257eada67d2.png)

#### **1.4 轴承删除**

点击轴承列表页面的“删除”按钮，在出现二次确认弹窗后，点击确定按钮，可完成对轴承的删除操作，已使用的轴承不允许删除。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ebb99835.png)

### **2.采集配置**

#### **2.1 功能概述**

采集配置模块主要是采集配置的添加、编辑、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ec46150f.png)

#### **2.2 采集配置添加**

点击页面右上角的“添加配置”按钮，进入采集配置的添加弹窗，填写相关信息后，点击确定按钮即可添加配置完成。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ed06d871.png)

#### **2.3 采集配置编辑**

已添加的采集配置需要更新时，点击页面的“编辑”按钮，进入到编辑弹窗界面，修改更新后，点击确定按钮完成采集配置的编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257eda46178.png)

#### **2.4 采集配置删除**

已使用的采集配置不允许删除，点击页面的删除按钮，出现二次确认弹窗，点击确定按钮后，完成对未使用的采集配置的删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257eea222ee.png)

### **3.产品型号**

#### **3.1 功能概述**

产品型号模块，用户可以进行产品型号的添加、编辑、删除操作，产品型号主要用于传感器添加、数采网关添加和采集配置添加。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257ef4c8531.png)

#### **3.2 产品型号添加**

进入产品型号列表页，点击页面右上角“添加”按钮，出现产品型号添加弹窗，填写产品型号、产品类型、产品子类型、产品图片，产品属性信息中填写通道数量、传输方式、通讯方式后，点击确定按钮，即可添加产品型号成功，备注栏用户可以自定义备注信息；需要给产品型号添加其他属性信息时，可以自主选择字典中添加的产品属性信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f02220bf.png)

#### **3.3 产品型号编辑**

已添加的产品型号会展示在产品型号列表页，按照添加时间倒序排列展示；用户点击选中的产品型号的编辑按钮，进入到产品型号编辑弹窗界面，产品型号的产品型号、产品类型、产品子类型不允许编辑，其他信息可以进行更新操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f0bbee65.png)

#### **3.4 产品型号删除**

已经被使用的产品型号不允许被删除，只有未被使用的产品型号可以进行删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f15d19c5.png)

#### **3.5 产品型号详情**

点击列表页的产品型号的产品型号名称，进入产品型号详情页面，展示产品型号的基本信息、属性信息、采集配置信息。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f227e804.png)
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f2295ee1.png)

### **4.字典管理**

#### **4.1 功能概述**

字典管理模块主要为了解决使用者自主编辑添加产品型号属性信息，其他使用属性信息。字典管理主要有字典编辑、字典删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f310db29.png)

#### **4.2 字典添加**

字典添加为系统内置字典信息，在页面不能进行添加操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f3b26750.png)

#### **4.3 字典编辑**

已添加的字典会展示在字典管理列表页，按照添加时间倒序排列展示；用户点击选中的字典的编辑按钮，进入到字典编辑弹窗界面，字典英文名称不允许编辑，其他信息可以进行更新操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f48b12f9.png)

#### **4.4 字典删除**

点击选中的字典的删除按钮可进行字典删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f538b479.png)

## 账户管理

### **1.用户管理**

#### **1.1 功能概述**

用户管理模块，可以进行用户的添加、编辑、重置密码、启用、停用、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f5d20b25.png)

#### **1.2 用户添加**

点击页面右上角“添加用户”按钮，进入用户添加弹窗，填写必填信息后，点击确定按钮，完成用户添加操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f6557775.png)

#### **1.3 用户编辑**

对已有用户进行用户名称、联系电话、部门、角色进行更新操作时，点击页面的“编辑”按钮，进入编辑弹窗界面，更新相关信息后，点击确定按钮，完成用户编辑。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f723e7fa.png)

#### **1.4 重置密码**

在用户使用过程中出现密码遗忘时，可通过联系管理员进行密码重置。鼠标悬浮到页面“更多”按钮，点击“密码重置”。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f7bb4725.png)

#### **1.5 停用账号**

对与启用状态的账号，可以进行停用操作，停用之后的账号不再具有平台登录使用权限。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f8595aad.png)

#### **1.6 启用账号**

对于停用的账号可以再次进行启用，启用成功后恢复账号的使用权限。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f90efe11.png)

#### **1.7 账号删除**

在进行用户管理过程中需要删除一些用户时，鼠标悬浮到“更多”按钮，点击“删除”，出现二次确认弹窗后，点击确定按钮即可完成用户删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257f9a3ce91.png)

### **2.角色管理**

#### **2.1 功能概述**

角色管理模块主要是角色的添加、编辑、删除操作，角色决定角色下的用户的使用权限范围。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fa43b275.png)

#### **2.2 添加角色**

点击页面右上角“添加角色”按钮，进入新增角色弹窗界面，填写角色名称选择角色权限后，点击确定按钮完成新角色的添加。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fab9f558.png)

#### **2.3 编辑角色**

在需要更改角色权限时，点击页面的“编辑”按钮，进入编辑角色弹窗界面，更新角色权限后，点击确定按钮，完成角色编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fb493706.png)

#### **2.4 删除角色**

在不需要某个角色时，点击页面“删除”按钮，出现二次确认弹窗，点击确定按钮后，完成对角色的删除操作。已使用的角色不允许删除。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fbea428b.png)

### **3.部门管理**

#### **3.1 功能概述**

部门管理模块包括部门的添加、编辑、删除操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fc799bd7.png)

#### **3.2 添加部门**

点击页面右上角“添加部门”按钮，进入部门添加弹窗界面，填写部门名称、所属部门，点击确定按钮，完成部门添加操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fd057b7f.png)

#### **3.3 编辑部门**

点击页面操作栏的“编辑”按钮，进入编辑部门弹窗界面，更新部门信息后，点击确定按钮，完成部门编辑操作。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fd8d1a36.png)

#### **3.4 删除部门**

点击页面“删除”按钮，出现二次确认弹窗，点击确定按钮后，进行部门删除操作，部门下存在用户时，不允许删除。
![](https://resource.helplook.net/docker_production/3648ne/article/mQrGwo1l/68257fe086d3e.png)